
//
// To jest przykadowy kod z podrozdziau 19.4.2 Wyznanie na temat makr ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <iostream>
#include <stdexcept>
#include <string>
#include <vector>

//------------------------------------------------------------------------------

// Klasa do raportowania o bdach zakresu.
struct out_of_range 
{
    out_of_range(const std::string& error_message) {}
};

//------------------------------------------------------------------------------

struct Range_error : out_of_range { // Ulepszony wektor zgaszajcy bdy zakresu.
    int index;
    Range_error(int i) :out_of_range("Bd zakresu"), index(i) { }
};

//------------------------------------------------------------------------------

template<class T> struct Vector : public std::vector<T> {
    typedef typename std::vector<T>::size_type size_type;

    Vector() { }
    Vector(size_type n) :std::vector<T>(n) {}
    Vector(size_type n, const T& v) :std::vector<T>(n,v) {}

    T& operator[](unsigned int i) // zamiast return at(i);
    {
        if (i<0||this->size()<=i) throw Range_error(i);
        return std::vector<T>::operator[](i);
    }

    const T& operator[](unsigned int i) const
    {
        if (i<0||this->size()<=i) throw Range_error(i);
        return std::vector<T>::operator[](i);
    }
};

//------------------------------------------------------------------------------

// Obrzydliwa sztuczka przy uyciu makra, ktrej celem jest uzyskanie kontrolowanego wektora:
#define vector Vector

int main()
try
{
    vector<int> v(10);
    v[20] = 5; // Prba dostpu do nieprawidowego indeksu.
}
catch (std::exception& e) {
    std::cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    std::cerr << "Ojej: nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
